#!/bin/sh
#
# Grants podman access to an Artifact Registry.
#
# The user must ssh into the server using this SSH agent and must be
# logged into "gcloud" on their local machine.
#
# Usage: access_gar.sh login [registry-ro | registry-rw]
#        access_gar.sh url

set -eu

cmd="${1:-}"
shift

location="northamerica-northeast2"
host="${location}-docker.pkg.dev"
url="https://$host"
docker_url="docker://$host/test-123/my-registry"

case $cmd in
login)
    # Login by getting access token from agent, giving to podman
    if test -z "${1:-}"; then
        auth_id="registry-ro"
    else
        auth_id="$1"
    fi
    token=$(agent_get_token.py --auth-id "$auth_id")
    echo "$token" | podman login -u oauth2accesstoken --password-stdin "$url"
    echo "$auth_id access to Artifact Registry granted to podman."
    echo "Registry URL is $docker_url"
    ;;
url)
    # Show the docker URL for the registry
    echo "$docker_url"
    ;;
*)
    echo "Usage: $(basename $0) [login|url] [...]"
    exit 1
    ;;
esac
