#!/usr/bin/env python3
import argparse
import os
import socket
import struct


def pack_msg(msg):
    return struct.pack('>I', len(msg)) + msg


def pack_type(msg_type):
    return struct.pack('>b', msg_type)


def recv_msg(conn):
    buf = conn.recv(4)
    if not buf:
        return b''
    (length,) = struct.unpack('>I', buf)
    contents = conn.recv(length)
    return contents


# message type an "exension"
SSH_AGENTC_EXTENSION = 27


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        '--sock', '-s', default=None, help="Path to SSH auth socket"
    )
    parser.add_argument(
        '--auth-id',
        '-I',
        default='registry-ro',
        help="ID of user account for access token.",
    )
    args = parser.parse_args()
    if args.sock:
        fn = args.sock
    else:
        fn = os.environ['SSH_AUTH_SOCK']

    client = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    client.connect(fn)
    cmd = f'token@py-ssh-agent.python.ca token {args.auth_id}'
    content = cmd.encode('utf-8')
    msg = pack_msg(pack_type(SSH_AGENTC_EXTENSION) + content)
    client.sendall(msg)
    contents = recv_msg(client)
    print(contents.decode('utf-8'))
    client.close()


if __name__ == '__main__':
    main()
